%
% Copyright 2009 Free Software Foundation, Inc.
% 
% This file is part of GNU Radio
% 
% GNU Radio is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3, or (at your option)
% any later version.
% 
% GNU Radio is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with GNU Radio; see the file COPYING.  If not, write to
% the Free Software Foundation, Inc., 51 Franklin Street,
% Boston, MA 02110-1301, USA.
% 

function v = filter_nonfinite (M)

  %% usage: filter_nonfinite (M)
  %%
  %%  replace all non-finite values of matrix M with a finite replacement value, 
  %%  NaN, Inf and -Inf are all considered non-finite values

  v=M; 
  [nr, nc] = size(v);
  not_inited=1;
  maxval=0;
  minval=0;
  for x=1:nr
   for y=1:nc
    curval=v(x,y);
    if finite(curval)
     if not_inited
      maxval=curval;
      minval=curval;
      not_inited=0;
     endif;
     if curval>maxval
      maxval=curval;
     endif;
     if curval <minval
       minval=curval;
     endif;
    endif; 
   endfor;
  endfor;
  if maxval>0
   replaceval_inf=maxval*2.0;
  else
   replaceval_inf=1.0;
  endif
  if minval<0
   replaceval_mininf=minval*2.0;
  else
   replaceval_mininf=-1.0;
  endif
  replaceval_nan=0.0;

  for x=1:nr
   for y=1:nc
    curval=v(x,y);
    if !finite(curval)
     v(x,y)=0.0;
     if isnan(curval)
      v(x,y)=replaceval_nan;
     endif;
     if Inf==curval
      v(x,y)=replaceval_inf;
     endif;
     if -Inf==curval
      v(x,y)=replaceval_mininf;
     endif;
    endif;
   endfor;
  endfor;

