#!/usr/bin/env python
##################################################
# Gnuradio Python Flow Graph
# Title: phase array, 4 antenna
# Author: Martin Dudok van Heel, Dimitri Stolnikov
# Description: 4 Antenna phase array using 2 TVRX2 daughterboards on USRP1
# Generated: Mon Aug 22 00:07:43 2011
##################################################

from gnuradio import eng_notation
from gnuradio import gr
from gnuradio import window
from gnuradio.eng_option import eng_option
from gnuradio.gr import firdes
from gnuradio.wxgui import fftsink2
from gnuradio.wxgui import forms
from gnuradio.wxgui import scopesink2
from grc_gnuradio import wxgui as grc_wxgui
from optparse import OptionParser
import wx

class mdvh_phaARR_filesource(grc_wxgui.top_block_gui):

	def __init__(self, center_freq=446.0e6):
		grc_wxgui.top_block_gui.__init__(self, title="phase array, 4 antenna")

		##################################################
		# Parameters
		##################################################
		self.center_freq = center_freq

		##################################################
		# Variables
		##################################################
		self.decim = decim = 256
		self.samp_rate = samp_rate = 64e6/decim
		self.ref_lev = ref_lev = -30
		self.ampgain = ampgain = 100

		##################################################
		# Blocks
		##################################################
		self.notebook = self.notebook = wx.Notebook(self.GetWin(), style=wx.NB_TOP)
		self.notebook.AddPage(grc_wxgui.Panel(self.notebook), "xy phasediff 0-1")
		self.notebook.AddPage(grc_wxgui.Panel(self.notebook), "amp 0,phasediff 0-1,0-2,0-3")
		self.notebook.AddPage(grc_wxgui.Panel(self.notebook), "spectrum 0")
		self.notebook.AddPage(grc_wxgui.Panel(self.notebook), "spectrum 1")
		self.notebook.AddPage(grc_wxgui.Panel(self.notebook), "spectrum 2")
		self.notebook.AddPage(grc_wxgui.Panel(self.notebook), "spectrum 3")
		self.notebook.AddPage(grc_wxgui.Panel(self.notebook), "angle")
		self.Add(self.notebook)
		_ampgain_sizer = wx.BoxSizer(wx.VERTICAL)
		self._ampgain_text_box = forms.text_box(
			parent=self.GetWin(),
			sizer=_ampgain_sizer,
			value=self.ampgain,
			callback=self.set_ampgain,
			label='ampgain',
			converter=forms.float_converter(),
			proportion=0,
		)
		self._ampgain_slider = forms.slider(
			parent=self.GetWin(),
			sizer=_ampgain_sizer,
			value=self.ampgain,
			callback=self.set_ampgain,
			minimum=1,
			maximum=10000,
			num_steps=100,
			style=wx.SL_HORIZONTAL,
			cast=float,
			proportion=1,
		)
		self.Add(_ampgain_sizer)
		self.xysink_0 = scopesink2.scope_sink_f(
			self.notebook.GetPage(6).GetWin(),
			title="Scope Plot",
			sample_rate=samp_rate,
			v_scale=0.001,
			v_offset=0,
			t_scale=0.001,
			ac_couple=False,
			xy_mode=True,
			num_inputs=2,
			trig_mode=gr.gr_TRIG_MODE_AUTO,
			y_axis_label="Counts",
		)
		self.notebook.GetPage(6).Add(self.xysink_0.win)
		self.xysink = scopesink2.scope_sink_c(
			self.notebook.GetPage(0).GetWin(),
			title="Scope Plot",
			sample_rate=samp_rate,
			v_scale=0.001,
			v_offset=0,
			t_scale=0.001,
			ac_couple=False,
			xy_mode=True,
			num_inputs=1,
			trig_mode=gr.gr_TRIG_MODE_AUTO,
			y_axis_label="Counts",
		)
		self.notebook.GetPage(0).Add(self.xysink.win)
		self.wxgui_scopesink2_0 = scopesink2.scope_sink_f(
			self.notebook.GetPage(1).GetWin(),
			title="Scope Plot",
			sample_rate=samp_rate,
			v_scale=1,
			v_offset=0,
			t_scale=0,
			ac_couple=False,
			xy_mode=False,
			num_inputs=4,
			trig_mode=gr.gr_TRIG_MODE_AUTO,
			y_axis_label="Counts",
		)
		self.notebook.GetPage(1).Add(self.wxgui_scopesink2_0.win)
		self.wxgui_fftsink2_0_0_1 = fftsink2.fft_sink_c(
			self.notebook.GetPage(5).GetWin(),
			baseband_freq=0,
			y_per_div=10,
			y_divs=10,
			ref_level=ref_lev,
			ref_scale=2.0,
			sample_rate=samp_rate,
			fft_size=1024,
			fft_rate=10,
			average=False,
			avg_alpha=None,
			title="FFT Plot",
			peak_hold=False,
			win=window.hanning,
		)
		self.notebook.GetPage(5).Add(self.wxgui_fftsink2_0_0_1.win)
		self.wxgui_fftsink2_0_0_0 = fftsink2.fft_sink_c(
			self.notebook.GetPage(4).GetWin(),
			baseband_freq=0,
			y_per_div=10,
			y_divs=10,
			ref_level=ref_lev,
			ref_scale=2.0,
			sample_rate=samp_rate,
			fft_size=1024,
			fft_rate=10,
			average=False,
			avg_alpha=None,
			title="FFT Plot",
			peak_hold=False,
		)
		self.notebook.GetPage(4).Add(self.wxgui_fftsink2_0_0_0.win)
		self.wxgui_fftsink2_0_0 = fftsink2.fft_sink_c(
			self.notebook.GetPage(3).GetWin(),
			baseband_freq=0,
			y_per_div=10,
			y_divs=10,
			ref_level=ref_lev,
			ref_scale=2.0,
			sample_rate=samp_rate,
			fft_size=1024,
			fft_rate=10,
			average=False,
			avg_alpha=None,
			title="FFT Plot",
			peak_hold=False,
		)
		self.notebook.GetPage(3).Add(self.wxgui_fftsink2_0_0.win)
		self.wxgui_fftsink2_0 = fftsink2.fft_sink_c(
			self.notebook.GetPage(2).GetWin(),
			baseband_freq=0,
			y_per_div=10,
			y_divs=10,
			ref_level=ref_lev,
			ref_scale=2.0,
			sample_rate=samp_rate,
			fft_size=1024,
			fft_rate=10,
			average=False,
			avg_alpha=None,
			title="FFT Plot",
			peak_hold=False,
			win=window.hanning,
		)
		self.notebook.GetPage(2).Add(self.wxgui_fftsink2_0.win)
		self.gr_throttle_0 = gr.throttle(gr.sizeof_gr_complex*1, samp_rate)
		self.gr_multiply_xx_2 = gr.multiply_vcc(1)
		self.gr_multiply_xx_1 = gr.multiply_vcc(1)
		self.gr_multiply_xx_0 = gr.multiply_vcc(1)
		self.gr_multiply_const_vxx_0 = gr.multiply_const_vff((ampgain, ))
		self.gr_file_source_3 = gr.file_source(gr.sizeof_gr_complex*1, "/tmp/channel3.cfile", True)
		self.gr_file_source_2 = gr.file_source(gr.sizeof_gr_complex*1, "/tmp/channel2.cfile", True)
		self.gr_file_source_1 = gr.file_source(gr.sizeof_gr_complex*1, "/tmp/channel1.cfile", True)
		self.gr_file_source_0 = gr.file_source(gr.sizeof_gr_complex*1, "/tmp/channel0.cfile", True)
		self.gr_conjugate_cc_3 = gr.conjugate_cc()
		self.gr_conjugate_cc_1 = gr.conjugate_cc()
		self.gr_conjugate_cc_0 = gr.conjugate_cc()
		self.gr_complex_to_mag_squared_0 = gr.complex_to_mag_squared(1)
		self.gr_complex_to_arg_2 = gr.complex_to_arg(1)
		self.gr_complex_to_arg_1 = gr.complex_to_arg(1)
		self.gr_complex_to_arg_0 = gr.complex_to_arg(1)

		##################################################
		# Connections
		##################################################
		self.connect((self.gr_conjugate_cc_0, 0), (self.gr_multiply_xx_0, 1))
		self.connect((self.gr_conjugate_cc_1, 0), (self.gr_multiply_xx_1, 1))
		self.connect((self.gr_conjugate_cc_3, 0), (self.gr_multiply_xx_2, 1))
		self.connect((self.gr_multiply_xx_0, 0), (self.gr_complex_to_arg_0, 0))
		self.connect((self.gr_multiply_xx_1, 0), (self.gr_complex_to_arg_1, 0))
		self.connect((self.gr_complex_to_mag_squared_0, 0), (self.gr_multiply_const_vxx_0, 0))
		self.connect((self.gr_multiply_xx_2, 0), (self.gr_complex_to_arg_2, 0))
		self.connect((self.gr_multiply_const_vxx_0, 0), (self.wxgui_scopesink2_0, 0))
		self.connect((self.gr_complex_to_arg_0, 0), (self.wxgui_scopesink2_0, 1))
		self.connect((self.gr_complex_to_arg_1, 0), (self.wxgui_scopesink2_0, 2))
		self.connect((self.gr_complex_to_arg_2, 0), (self.wxgui_scopesink2_0, 3))
		self.connect((self.gr_multiply_xx_0, 0), (self.xysink, 0))
		self.connect((self.gr_file_source_1, 0), (self.gr_conjugate_cc_0, 0))
		self.connect((self.gr_file_source_2, 0), (self.gr_conjugate_cc_1, 0))
		self.connect((self.gr_file_source_3, 0), (self.gr_conjugate_cc_3, 0))
		self.connect((self.gr_file_source_3, 0), (self.wxgui_fftsink2_0_0_0, 0))
		self.connect((self.gr_file_source_2, 0), (self.wxgui_fftsink2_0_0_1, 0))
		self.connect((self.gr_file_source_1, 0), (self.wxgui_fftsink2_0_0, 0))
		self.connect((self.gr_file_source_0, 0), (self.gr_throttle_0, 0))
		self.connect((self.gr_throttle_0, 0), (self.gr_complex_to_mag_squared_0, 0))
		self.connect((self.gr_throttle_0, 0), (self.gr_multiply_xx_0, 0))
		self.connect((self.gr_throttle_0, 0), (self.gr_multiply_xx_1, 0))
		self.connect((self.gr_throttle_0, 0), (self.gr_multiply_xx_2, 0))
		self.connect((self.gr_throttle_0, 0), (self.wxgui_fftsink2_0, 0))
		self.connect((self.gr_complex_to_arg_0, 0), (self.xysink_0, 0))
		self.connect((self.gr_complex_to_arg_1, 0), (self.xysink_0, 1))

	def get_center_freq(self):
		return self.center_freq

	def set_center_freq(self, center_freq):
		self.center_freq = center_freq

	def get_decim(self):
		return self.decim

	def set_decim(self, decim):
		self.decim = decim
		self.set_samp_rate(64e6/self.decim)

	def get_samp_rate(self):
		return self.samp_rate

	def set_samp_rate(self, samp_rate):
		self.samp_rate = samp_rate
		self.wxgui_scopesink2_0.set_sample_rate(self.samp_rate)
		self.wxgui_fftsink2_0_0_0.set_sample_rate(self.samp_rate)
		self.wxgui_fftsink2_0_0_1.set_sample_rate(self.samp_rate)
		self.wxgui_fftsink2_0_0.set_sample_rate(self.samp_rate)
		self.wxgui_fftsink2_0.set_sample_rate(self.samp_rate)
		self.xysink.set_sample_rate(self.samp_rate)
		self.xysink_0.set_sample_rate(self.samp_rate)

	def get_ref_lev(self):
		return self.ref_lev

	def set_ref_lev(self, ref_lev):
		self.ref_lev = ref_lev

	def get_ampgain(self):
		return self.ampgain

	def set_ampgain(self, ampgain):
		self.ampgain = ampgain
		self.gr_multiply_const_vxx_0.set_k((self.ampgain, ))
		self._ampgain_slider.set_value(self.ampgain)
		self._ampgain_text_box.set_value(self.ampgain)

if __name__ == '__main__':
	parser = OptionParser(option_class=eng_option, usage="%prog: [options]")
	parser.add_option("-f", "--center-freq", dest="center_freq", type="eng_float", default=eng_notation.num_to_str(446.0e6),
		help="Set freq [default=%default]")
	(options, args) = parser.parse_args()
	tb = mdvh_phaARR_filesource(center_freq=options.center_freq)
	tb.Run(True)

