#!/usr/bin/env python
##################################################
# Gnuradio Python Flow Graph
# Title: convert complex short to complex float
# Author: Martin Dudok van Heel
# Description: convert complex short file (interleaved short)  to complex float file
# Generated: Tue Jun  9 18:43:38 2015
##################################################

from gnuradio import eng_notation
from gnuradio import gr
from gnuradio.eng_option import eng_option
from gnuradio.gr import firdes
from optparse import OptionParser

class convert_cshort_to_cfloat(gr.top_block):

	def __init__(self, in_file="", out_file="", max_nsamples=-1, scale=1.0):
		gr.top_block.__init__(self, "convert complex short to complex float")

		##################################################
		# Parameters
		##################################################
		self.in_file = in_file
		self.out_file = out_file
		self.max_nsamples = max_nsamples
		self.scale = scale

		##################################################
		# Blocks
		##################################################
		self.multiply_const = gr.multiply_const_vcc((scale, ))
		self.head = gr.head(gr.sizeof_gr_complex*1, max_nsamples)
		self.gr_interleaved_short_to_complex_0 = gr.interleaved_short_to_complex()
		self.file_source = gr.file_source(gr.sizeof_short*1, in_file, False)
		self.file_sink = gr.file_sink(gr.sizeof_gr_complex*1, out_file)
		self.file_sink.set_unbuffered(False)

		##################################################
		# Connections
		##################################################
		self.connect((self.file_source, 0), (self.gr_interleaved_short_to_complex_0, 0))
		self.connect((self.multiply_const, 0), (self.file_sink, 0))
		self.connect((self.gr_interleaved_short_to_complex_0, 0), (self.head, 0))
		self.connect((self.head, 0), (self.multiply_const, 0))

	def get_in_file(self):
		return self.in_file

	def set_in_file(self, in_file):
		self.in_file = in_file

	def get_out_file(self):
		return self.out_file

	def set_out_file(self, out_file):
		self.out_file = out_file
		self.file_sink.open(self.out_file)

	def get_max_nsamples(self):
		return self.max_nsamples

	def set_max_nsamples(self, max_nsamples):
		self.max_nsamples = max_nsamples

	def get_scale(self):
		return self.scale

	def set_scale(self, scale):
		self.scale = scale
		self.multiply_const.set_k((self.scale, ))

if __name__ == '__main__':
	parser = OptionParser(option_class=eng_option, usage="%prog: [options]")
	parser.add_option("-i", "--in-file", dest="in_file", type="string", default="",
		help="Set in_file [default=%default]")
	parser.add_option("-o", "--out-file", dest="out_file", type="string", default="",
		help="Set out_file [default=%default]")
	parser.add_option("-n", "--max-nsamples", dest="max_nsamples", type="intx", default=-1,
		help="Set maximum nomber of sampels to process [default=%default]")
	parser.add_option("-s", "--scale", dest="scale", type="eng_float", default=eng_notation.num_to_str(1.0),
		help="Set multiply all samples by this value. Default 1.0 [default=%default]")
	(options, args) = parser.parse_args()
	tb = convert_cshort_to_cfloat(in_file=options.in_file, out_file=options.out_file, max_nsamples=options.max_nsamples, scale=options.scale)
	tb.run()

